
unit main;

interface

uses
    Windows, Messages, SysUtils,
    Classes, Graphics, Controls, Forms,
    Dialogs, StdCtrls ;

type
    TForm1 = class(TForm)
    List: TListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FromClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    private
        { Private declarations }
    public
        { Public declarations }
    end;

var
    Form1: TForm1;
    hRY2: THandle;


implementation

uses head;

{$R *.dfm}


procedure TForm1.FormCreate(Sender: TObject);
var
str :string;
retcode :integer;
begin
    List.Items.Clear();
    hRY2:=Loadlibrary('Rockey2.dll');
    if hRY2 = 0 then
    begin
        List.Items.Add('Can not find Rockey2.dll');
        exit;
    end;

    RY2_Find := GetProcAddress(hRY2, 'RY2_Find');
    RY2_Open := GetProcAddress(hRY2, 'RY2_Open');
    RY2_Close := GetProcAddress(hRY2, 'RY2_Close');
    RY2_GenUID := GetProcAddress(hRY2,'RY2_GenUID');
    RY2_Write := GetProcAddress(hRY2,'RY2_Write');
    RY2_Read:= GetProcAddress(hRY2,'RY2_Read');


end;

procedure TForm1.FromClose(Sender: TObject; var Action: TCloseAction);
begin
     Freelibrary(hRY2);
end;


procedure TForm1.Button2Click(Sender: TObject);
var
retcode ,handle:integer;
uid,hid:cardinal;
str :string;

begin
	// generate UID
	// There must be one dongle pluging in computer when generating UID,so we don't care the UID and
	//  HID of it .We only use the first dongle.
        retcode := RY2_Find();
    if (retcode < 0) then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
    	List.Items.Add(str);
    	exit;
    end;
    if (retcode = 0)     then
    begin
    	List.Items.Add('ERROR: Not found any rockey2');
    	exit;
    end ;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);

	retcode := RY2_Open(AUTO_MODE, 0, hid);
	if retcode < 0 then
	begin
                FmtStr(str, 'ERROR of RY2_Open : %x', [retcode]);
		List.Items.Add(str);
		exit;
	end  ;
	handle := retcode;

       str := Inputbox('Input','Please input seed : ','12345');
       retcode := RY2_GenUID(handle, uid, PChar(str), ROCKEY2_DISABLE_WRITE_PROTECT);
	if  retcode < 0 then
	begin
                FmtStr(str, 'ERROR: %x', [retcode]);
		List.Items.Add(str);
		exit;
	end ;
        FmtStr(str,'UID is %d', [uid]);
	List.Items.Add(str);
	RY2_Close(handle);
       	// after generated new UID, the flag of dongle has changed,you must plug out it and re-plug again
	List.Items.Add('You must plug out Rockey2 and re-plug to enable new uid.');
end;

procedure TForm1.Button3Click(Sender: TObject);
var
retcode ,handle,block_index:integer;
uid,hid:cardinal;
str :string;
begin
	// write dongle with appointed UID
        retcode := RY2_Find();
    if (retcode < 0) then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
    	List.Items.Add(str);
    	exit;
    end;
    if (retcode = 0)     then
    begin
    	List.Items.Add('ERROR: Not found any rockey2');
    	exit;
    end ;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);

        str := Inputbox('Input','please input uid : ','715400947');
        List.Items.Add(str);
        uid := StrToInt(str);
	retcode := RY2_Open(1, uid, hid);
	if retcode < 0 then
	begin
                FmtStr(str,'ERROR: %x', [retcode]);
		List.Items.Add(str);
        	exit;
	end;
	handle := retcode;

  str := Inputbox('Input','Please input write block index(0-4)','0');
  if length(str)=0 then
      Exit;
    block_index := StrToInt(str);
    if (block_index>4) or (block_index<0) then
    begin
        List.Items.Add('Err in block index ');
      Exit;
    end;
        str := Inputbox('Input','Please input write data :','helloworld');
	retcode := RY2_Write(handle, block_index, PChar(str));
	if  retcode < 0 then
	begin
             FmtStr(str, 'ERROR: %x', [retcode]);
	     List.Items.Add(str);
	     exit;
	end;
	List.Items.Add('Write OK');
	RY2_Close(handle);

end;

procedure TForm1.Button4Click(Sender: TObject);
var
retcode ,handle,block_index:integer;
uid,hid:cardinal;
buffer :array [0..512]of char;
str:string;
pchars :PChar;
begin
   // read dongle with appointed UID
   retcode := RY2_Find();
    if (retcode < 0) then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
    	List.Items.Add(str);
    	exit;
    end;
    if (retcode = 0)     then
    begin
    	List.Items.Add('ERROR: Not found any rockey2');
    	exit;
    end ;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);
   str := Inputbox('Input','please input uid : ','715400947');
   uid := StrToInt(str);
   retcode := RY2_Open(1, uid, hid);
   if  retcode < 0 then
   begin
      FmtStr(str, 'ERROR: %x', [retcode]);
      List.Items.Add(str);
      exit;
   end ;
   handle := retcode;

   str := Inputbox('Input','Please input write block index(0-4)','0');
   if length(str)=0 then
      Exit;
    block_index := StrToInt(str);
    if (block_index>4) or (block_index<0) then
    begin
        List.Items.Add('Err in block index ');
      Exit;
    end;
   retcode := RY2_Read(handle, block_index, buffer);
   if retcode < 0 then
   begin
        FmtStr(str, 'ERROR: %x', [retcode]);
   	List.Items.Add(str);
   	exit;
   end ;
   pchars := buffer;
   str := 'Readed data: '+pchars;
   List.Items.Add(str);
   RY2_Close(handle);
end;

end.



